<?php
session_start();
$config = require __DIR__ . '/../config.php';

// SIMPLE PASSWORD (change this!)
$pw = 'apitechs_test';

// logout
if (isset($_GET['logout'])) {
    session_destroy();
    header('Location: index.php');
    exit;
}

// already logged in → go to accounts
if (!empty($_SESSION['admin'])) {
    header('Location: accounts_list.php');
    exit;
}

$err = '';
if (isset($_POST['password'])) {
    if ($_POST['password'] === $pw) {
        session_regenerate_id(true);
        $_SESSION['admin'] = true;
        header('Location: accounts_list.php');
        exit;
    } else {
        $err = 'Wrong password. Try again.';
    }
}
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<title>Admin Login</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<style>
  :root{
    --bg:#050512;
    --bg-soft:#09091b;
    --card:#10101f;
    --card-inner:#f9fafb;
    --accent:#6c5ce7;
    --accent-soft:#a29bfe;
    --accent-2:#0ea5e9;
    --error:#f97373;
    --text-main:#f9fafb;
    --text-muted:#9ca3af;
    --border-soft:rgba(255,255,255,0.08);
  }
  *{box-sizing:border-box;margin:0;padding:0}

  body{
    min-height:100vh;
    font-family:system-ui,-apple-system,BlinkMacSystemFont,"Segoe UI",sans-serif;
    background:radial-gradient(circle at top,#1f2937 0,#020314 55%);
    color:var(--text-main);
    display:flex;
    align-items:center;
    justify-content:center;
    padding:18px;
    overflow:hidden;
  }

  /* animated gradient blobs */
  .orb{
    position:fixed;
    border-radius:999px;
    filter:blur(32px);
    opacity:.5;
    mix-blend-mode:screen;
    pointer-events:none;
    z-index:0;
  }
  .orb.one{
    width:420px;height:420px;
    background:radial-gradient(circle,var(--accent) 0,transparent 70%);
    top:-120px;left:-80px;
    animation:float1 18s ease-in-out infinite alternate;
  }
  .orb.two{
    width:360px;height:360px;
    background:radial-gradient(circle,var(--accent-2) 0,transparent 70%);
    bottom:-120px;right:-60px;
    animation:float2 22s ease-in-out infinite alternate;
  }
  @keyframes float1{
    0%{transform:translate3d(0,0,0);}
    100%{transform:translate3d(40px,60px,0);}
  }
  @keyframes float2{
    0%{transform:translate3d(0,0,0);}
    100%{transform:translate3d(-40px,-50px,0);}
  }

  .shell{
    position:relative;
    z-index:1;
    width:100%;
    max-width:480px;
  }

  .card{
    background:linear-gradient(135deg,rgba(15,23,42,0.95),rgba(15,23,42,0.8));
    border-radius:20px;
    padding:20px;
    border:1px solid var(--border-soft);
    box-shadow:0 24px 60px rgba(0,0,0,0.75);
    backdrop-filter:blur(10px);
    overflow:hidden;
    position:relative;
  }

  /* animated border glow */
  .card::before{
    content:"";
    position:absolute;
    inset:-2px;
    border-radius:22px;
    background:conic-gradient(from 180deg,var(--accent),var(--accent-2),var(--accent-soft),var(--accent));
    opacity:0.18;
    z-index:-1;
    filter:blur(6px);
    animation:borderSpin 18s linear infinite;
  }
  @keyframes borderSpin{
    0%{transform:rotate(0deg);}
    100%{transform:rotate(360deg);}
  }

  .inner{
    background:radial-gradient(circle at top,rgba(148,163,184,0.06),rgba(15,23,42,0.98));
    border-radius:16px;
    padding:18px 18px 20px;
  }

  .brand-row{
    display:flex;
    align-items:center;
    gap:12px;
    margin-bottom:10px;
  }
  .logo-dot{
    width:46px;height:46px;
    border-radius:14px;
    background:linear-gradient(135deg,var(--accent),var(--accent-soft));
    display:flex;
    align-items:center;
    justify-content:center;
    font-weight:800;
    font-size:18px;
    color:#f9fafb;
    box-shadow:0 10px 26px rgba(15,23,42,0.9);
  }
  .brand-text h1{
    font-size:22px;
    letter-spacing:.02em;
  }
  .brand-text p{
    font-size:13px;
    color:var(--text-muted);
    margin-top:4px;
  }

  .error{
    margin-top:8px;
    margin-bottom:10px;
    padding:9px 11px;
    border-radius:10px;
    font-size:13px;
    background:rgba(239,68,68,0.08);
    border:1px solid rgba(248,113,113,0.8);
    color:#fecaca;
  }

  form{
    margin-top:10px;
  }

  .field{
    margin-bottom:14px;
  }
  label{
    font-size:13px;
    font-weight:600;
    color:var(--text-muted);
    margin-bottom:5px;
    display:block;
  }
  .pw-wrap{
    position:relative;
  }
  input[type=password],
  input[type=text]{
    width:100%;
    padding:11px 46px 11px 11px;
    border-radius:11px;
    border:1px solid rgba(148,163,184,0.28);
    background:rgba(15,23,42,0.8);
    color:var(--text-main);
    font-size:14px;
    outline:none;
    transition:border-color .13s ease, box-shadow .13s ease, transform .08s ease;
  }
  input::placeholder{
    color:rgba(148,163,184,0.65);
  }
  input:focus{
    border-color:rgba(129,140,248,0.9);
    box-shadow:0 0 0 1px rgba(129,140,248,0.6),0 0 32px rgba(79,70,229,0.35);
    transform:translateY(-1px);
  }

  .toggle-btn{
    position:absolute;
    right:8px;
    top:50%;
    transform:translateY(-50%);
    border:none;
    padding:6px 9px;
    border-radius:999px;
    font-size:12px;
    font-weight:600;
    background:rgba(15,23,42,0.9);
    color:var(--text-muted);
    cursor:pointer;
    display:inline-flex;
    align-items:center;
    gap:4px;
  }
  .toggle-btn span.icon{
    font-size:13px;
  }

  .login-btn{
    width:100%;
    margin-top:4px;
    border:none;
    border-radius:999px;
    padding:11px 16px;
    font-size:15px;
    font-weight:700;
    color:#f9fafb;
    cursor:pointer;
    background:linear-gradient(120deg,var(--accent),var(--accent-soft),var(--accent-2));
    background-size:200% 200%;
    box-shadow:0 16px 36px rgba(15,23,42,0.85);
    position:relative;
    overflow:hidden;
    transform:translateY(0);
    transition:transform .12s ease, box-shadow .12s ease, background-position 1s ease-out;
  }
  .login-btn::after{
    content:"";
    position:absolute;
    inset:0;
    background:linear-gradient(120deg,rgba(255,255,255,0.18),transparent 60%);
    mix-blend-mode:soft-light;
    opacity:0;
    transform:translateX(-40%);
    transition:opacity .4s ease, transform .7s ease;
  }
  .login-btn:hover{
    background-position:100% 0;
    transform:translateY(-1px);
    box-shadow:0 20px 45px rgba(15,23,42,0.95);
  }
  .login-btn:hover::after{
    opacity:1;
    transform:translateX(40%);
  }
  .login-btn:active{
    transform:translateY(1px) scale(.995);
    box-shadow:0 10px 26px rgba(15,23,42,0.9);
  }

  .footer-row{
    margin-top:12px;
    display:flex;
    justify-content:space-between;
    align-items:center;
    font-size:12px;
    color:var(--text-muted);
  }
  .footer-row a{
    color:var(--text-muted);
    text-decoration:none;
    opacity:.85;
  }

  @media (max-width:480px){
    body{padding:14px;}
    .card{border-radius:18px;}
  }
</style>
</head>
<body>
  <div class="orb one"></div>
  <div class="orb two"></div>

  <div class="shell">
    <div class="card" role="main" aria-labelledby="login-heading">
      <div class="inner">
        <div class="brand-row">
          <div class="logo-dot" aria-hidden="true">PH</div>
          <div class="brand-text">
            <h1 id="login-heading">Admin Login</h1>
            <p>Secure panel for managing accounts, categories & payments.</p>
          </div>
        </div>

        <?php if ($err): ?>
          <div class="error" role="alert"><?= htmlspecialchars($err, ENT_QUOTES | ENT_SUBSTITUTE) ?></div>
        <?php endif; ?>

        <form method="post" autocomplete="off">
          <div class="field">
            <label for="password">Admin password</label>
            <div class="pw-wrap">
              <input
                id="password"
                type="password"
                name="password"
                placeholder="Enter your admin password"
                required
                autofocus
              >
              <button type="button" class="toggle-btn" id="toggleBtn" aria-pressed="false">
                <span class="icon">👁️</span><span class="label">Show</span>
              </button>
            </div>
          </div>

          <button class="login-btn" type="submit">Sign in</button>

          <div class="footer-row">
            <span>Powered by your loader panel</span>
            <a href="?logout=1">Force logout</a>
          </div>
        </form>
      </div>
    </div>
  </div>

<script>
  const pwInput  = document.getElementById('password');
  const toggle   = document.getElementById('toggleBtn');

  if (toggle && pwInput) {
    toggle.addEventListener('click', () => {
      const isHidden = pwInput.type === 'password';
      pwInput.type   = isHidden ? 'text' : 'password';
      toggle.setAttribute('aria-pressed', String(isHidden));
      toggle.querySelector('.label').textContent = isHidden ? 'Hide' : 'Show';
      const len = pwInput.value.length;
      try {
        pwInput.focus();
        pwInput.setSelectionRange(len, len);
      } catch(e){}
    });
  }

  // lil entrance animation
  window.addEventListener('load', () => {
    const card = document.querySelector('.card');
    card.style.opacity = '0';
    card.style.transform = 'translateY(10px)';
    requestAnimationFrame(() => {
      card.style.transition = 'opacity .35s ease, transform .35s ease';
      card.style.opacity = '1';
      card.style.transform = 'translateY(0)';
    });
  });
</script>
</body>
</html>